﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using RevisionAnalyser.Projects;

namespace RevisionAnalyser.Global
{
    public class ProjectTypes
    {
        private static ProjectTypes _instance;
        public static ProjectTypes Instance
        {
            get
            {
                if (_instance == null)
                {
                    _instance = new ProjectTypes();
                }
                return _instance;
            }
        }

        private Dictionary<string, Type> _projectTypes = new Dictionary<string, Type>();

        public void AddProjectType(string name, Type type)
        {
            _projectTypes.Add(name, type);
        }

        public ProjectType GetProjectType(string name)
        {
            if (_projectTypes.ContainsKey(name))
            {
                return (ProjectType)Activator.CreateInstance(_projectTypes[name]);
            }
            return null;
        }

        public List<ProjectType> GetProjectTypes()
        {
            List<ProjectType> list = new List<ProjectType>();
            foreach (KeyValuePair<string, Type> projectType in _projectTypes)
            {
                list.Add((ProjectType)Activator.CreateInstance(projectType.Value));
            }
            return list;
        }
    }
}
